/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.code.TagData;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItem;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public interface IBehavior<E extends Item> {
    public boolean onLeftClickEntity(E var1, ItemStack var2, EntityPlayer var3, Entity var4);

    public boolean onRightClickEntity(E var1, ItemStack var2, EntityPlayer var3, Entity var4);

    public boolean onItemUse(E var1, ItemStack var2, EntityPlayer var3, World var4, int var5, int var6, int var7, byte var8, float var9, float var10, float var11);

    public boolean onItemUseFirst(E var1, ItemStack var2, EntityPlayer var3, World var4, int var5, int var6, int var7, byte var8, float var9, float var10, float var11);

    public ItemStack onItemRightClick(E var1, ItemStack var2, World var3, EntityPlayer var4);

    public List<String> getAdditionalToolTips(E var1, List<String> var2, ItemStack var3);

    public void onUpdate(E var1, ItemStack var2, World var3, Entity var4, int var5, boolean var6);

    public boolean isItemStackUsable(E var1, ItemStack var2);

    public boolean canDispense(E var1, IBlockSource var2, ItemStack var3);

    public ItemStack onDispense(E var1, IBlockSource var2, ItemStack var3);

    public boolean hasProjectile(E var1, TagData var2, ItemStack var3);

    public IItemProjectile.EntityProjectile getProjectile(E var1, TagData var2, ItemStack var3, World var4, double var5, double var7, double var9);

    public IItemProjectile.EntityProjectile getProjectile(E var1, TagData var2, ItemStack var3, World var4, EntityLivingBase var5, float var6);

    @Deprecated
    public static abstract class Behaviour_None
    extends AbstractBehaviorDefault {
    }

    public static abstract class AbstractBehaviorDefault
    implements IBehavior<MultiItem> {
        @Override
        public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
            return false;
        }

        @Override
        public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
            return false;
        }

        @Override
        public boolean onItemUse(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
            return false;
        }

        @Override
        public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
            return false;
        }

        @Override
        public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
            return aStack;
        }

        @Override
        public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
            return aList;
        }

        @Override
        public void onUpdate(MultiItem aItem, ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        }

        @Override
        public boolean isItemStackUsable(MultiItem aItem, ItemStack aStack) {
            return true;
        }

        @Override
        public boolean canDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
            return false;
        }

        @Override
        public boolean hasProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack) {
            return false;
        }

        @Override
        public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
            return null;
        }

        @Override
        public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
            return null;
        }

        @Override
        public ItemStack onDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
            EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.getBlockMetadata());
            IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
            ItemStack itemstack1 = aStack.splitStack(1);
            BehaviorDefaultDispenseItem.doDispense((World)aSource.getWorld(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
            return aStack;
        }
    }
}

