/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IShearable;

public class Behavior_Shears
extends IBehavior.AbstractBehaviorDefault {
    private final int mCosts;

    public Behavior_Shears(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aEntity instanceof IShearable) {
            if (aPlayer.worldObj.isRemote) {
                return true;
            }
            if (((IShearable)aEntity).isShearable(aStack, (IBlockAccess)aPlayer.worldObj, (int)aEntity.posX, (int)aEntity.posY, (int)aEntity.posZ) && ((MultiItemTool)aItem).doDamage(aStack, this.mCosts, (EntityLivingBase)aPlayer, false)) {
                int tFortune = UT.NBT.getEnchantmentLevelLootingFortune(aStack);
                String tClass = UT.Reflection.getLowercaseClass(aEntity);
                boolean tDropIncrease = tFortune > 0 && ("EntitySheep".equalsIgnoreCase(tClass) || "EntityTFBighorn".equalsIgnoreCase(tClass) || "EntityTaintSheep".equalsIgnoreCase(tClass) || "EntitySheepuff".equalsIgnoreCase(tClass));
                for (ItemStack tStack : ((IShearable)aEntity).onSheared(aStack, (IBlockAccess)aPlayer.worldObj, (int)aEntity.posX, (int)aEntity.posY, (int)aEntity.posZ, tFortune)) {
                    if (tDropIncrease && ST.block(tStack) == Blocks.wool) {
                        tStack.stackSize += CS.RNGSUS.nextInt(1 + tFortune);
                        if (tStack.stackSize > 64) {
                            tStack.stackSize = 64;
                        }
                    }
                    ST.give((Entity)aPlayer, tStack, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onRightClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        return this.onLeftClickEntity(aItem, aStack, aPlayer, aEntity);
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.shears"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.shears", "Shaves Sheep, Mooshrooms and alike");
    }
}

