/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.TD;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public interface IItemEnergy {
    public boolean isEnergyType(TagData var1, ItemStack var2, boolean var3);

    public Collection<TagData> getEnergyTypes(ItemStack var1);

    public long doEnergyInjection(TagData var1, ItemStack var2, long var3, long var5, IInventory var7, World var8, int var9, int var10, int var11, boolean var12);

    public boolean canEnergyInjection(TagData var1, ItemStack var2, long var3);

    public long doEnergyExtraction(TagData var1, ItemStack var2, long var3, long var5, IInventory var7, World var8, int var9, int var10, int var11, boolean var12);

    public boolean canEnergyExtraction(TagData var1, ItemStack var2, long var3);

    public boolean useEnergy(TagData var1, ItemStack var2, long var3, EntityLivingBase var5, IInventory var6, World var7, int var8, int var9, int var10, boolean var11);

    public ItemStack setEnergyStored(TagData var1, ItemStack var2, long var3);

    public long getEnergyStored(TagData var1, ItemStack var2);

    public long getEnergyCapacity(TagData var1, ItemStack var2);

    public long getEnergySizeInputMin(TagData var1, ItemStack var2);

    public long getEnergySizeOutputMin(TagData var1, ItemStack var2);

    public long getEnergySizeInputRecommended(TagData var1, ItemStack var2);

    public long getEnergySizeOutputRecommended(TagData var1, ItemStack var2);

    public long getEnergySizeInputMax(TagData var1, ItemStack var2);

    public long getEnergySizeOutputMax(TagData var1, ItemStack var2);

    public static class Utility {
        public static long inject(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
            if (ST.invalid(aStack)) {
                return 0L;
            }
            if (aStack.getItem() instanceof IItemEnergy) {
                return ((IItemEnergy)aStack.getItem()).doEnergyInjection(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoInject);
            }
            if (aEnergyType == TD.Energy.EU && CS.COMPAT_EU_ITEM != null && CS.COMPAT_EU_ITEM.is(aStack) && !IL.IC2_EnergyCrystal.equal(aStack, true, true) && !IL.IC2_LapotronCrystal.equal(aStack, true, true) && CS.COMPAT_EU_ITEM.insidevolt(aStack, UT.Code.voltMin(aSize), UT.Code.voltMax(aSize)) && CS.COMPAT_EU_ITEM.charge(aStack, aSize, aDoInject) > 0L) {
                return 1L;
            }
            return 0L;
        }

        public static long extract(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
            if (ST.invalid(aStack)) {
                return 0L;
            }
            if (aStack.getItem() instanceof IItemEnergy) {
                return ((IItemEnergy)aStack.getItem()).doEnergyExtraction(aEnergyType, aStack, aSize, aAmount, aInventory, aWorld, aX, aY, aZ, aDoExtract);
            }
            if (aEnergyType == TD.Energy.EU && CS.COMPAT_EU_ITEM != null && CS.COMPAT_EU_ITEM.is(aStack) && !IL.IC2_EnergyCrystal.equal(aStack, true, true) && !IL.IC2_LapotronCrystal.equal(aStack, true, true) && CS.COMPAT_EU_ITEM.provider(aStack) && CS.COMPAT_EU_ITEM.insidevolt(aStack, UT.Code.voltMin(aSize), UT.Code.voltMax(aSize)) && CS.COMPAT_EU_ITEM.decharge(aStack, aSize, aDoExtract) >= aSize) {
                return 1L;
            }
            return 0L;
        }

        public static boolean full(ItemStack aStack, boolean aDefault) {
            if (ST.invalid(aStack)) {
                return aDefault;
            }
            if (aStack.getItem() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)aStack.getItem()).getEnergyTypes(aStack)) {
                    if (((IItemEnergy)aStack.getItem()).getEnergyStored(tEnergyType, aStack) >= ((IItemEnergy)aStack.getItem()).getEnergyCapacity(tEnergyType, aStack)) continue;
                    return false;
                }
            }
            if (CS.COMPAT_EU_ITEM != null && CS.COMPAT_EU_ITEM.is(aStack) && CS.COMPAT_EU_ITEM.stored(aStack) < CS.COMPAT_EU_ITEM.capacity(aStack)) {
                return false;
            }
            return aDefault;
        }

        public static boolean empty(ItemStack aStack, boolean aDefault) {
            if (ST.invalid(aStack)) {
                return aDefault;
            }
            if (aStack.getItem() instanceof IItemEnergy) {
                for (TagData tEnergyType : ((IItemEnergy)aStack.getItem()).getEnergyTypes(aStack)) {
                    if (((IItemEnergy)aStack.getItem()).getEnergyStored(tEnergyType, aStack) <= 0L) continue;
                    return false;
                }
            }
            if (CS.COMPAT_EU_ITEM != null && CS.COMPAT_EU_ITEM.is(aStack) && CS.COMPAT_EU_ITEM.stored(aStack) > 0L) {
                return false;
            }
            return aDefault;
        }
    }
}

