/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.AbstractCoverDefault;
import gregapi.data.LH;
import gregapi.render.BlockTextureCopied;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;

public class CoverTextureCanvas
extends AbstractCoverDefault {
    public final ITexture mTexture;
    public static final ITexture sCanvas = BlockTextureDefault.get("machines/covers/canvas");

    public CoverTextureCanvas(ITexture aTexture) {
        this.mTexture = aTexture;
    }

    @Override
    public void onCoverPlaced(byte aSide, CoverData aData, Entity aPlayer, ItemStack aCover) {
        if (aCover != null && aCover.hasTagCompound()) {
            aData.visual(aSide, (short)(aCover.getTagCompound().getInteger("gt.canvas.block") << 4 | aCover.getTagCompound().getInteger("gt.canvas.meta") & 0xF));
        }
        if (aPlayer != null) {
            UT.Sounds.send("dig.cloth", 1.0f, -1.0f, aData.mTileEntity);
        }
    }

    @Override
    public void onAfterCrowbar(ITileEntityCoverable aTileEntity) {
        UT.Sounds.send("dig.cloth", 1.0f, -1.0f, aTileEntity);
    }

    @Override
    public boolean needsVisualsSaved(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (aStack != null && aStack.hasTagCompound() && aStack.getTagCompound().hasKey("gt.canvas.block")) {
            aList.add(LH.Chat.CYAN + "Block Image: " + ST.names(ST.make(Block.getBlockById((int)aStack.getTagCompound().getInteger("gt.canvas.block")), 1L, (long)(aStack.getTagCompound().getInteger("gt.canvas.meta") & 0xF))));
        }
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return aData.mVisuals[aSide] == 0 ? null : BlockTextureCopied.get(Block.getBlockById((int)(aData.mVisuals[aSide] >>> 4 & 0xFFF)), 6, aData.mVisuals[aSide] & 0xF);
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide != aTextureSide ? this.mTexture : BlockTextureMulti.get(this.mTexture, this.getCoverTextureSurface(aSide, aData));
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return this.mTexture;
    }

    @Override
    public boolean isSealable(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public boolean isDecorative(byte aCoverSide, CoverData aData) {
        return true;
    }
}

