/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.block.fluid.BlockBaseFluid;
import gregapi.block.metatype.BlockMetaType;
import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import openblocks.common.LiquidXpUtils;
import openmods.utils.EnchantmentUtils;

public class CoverDrain
extends AbstractCoverAttachment {
    public static final ITexture sTextureSides = BlockTextureDefault.get("machines/covers/drain/sides");
    public static final ITexture sTextureFront = BlockTextureDefault.get("machines/covers/drain/front");
    public static final ITexture sTextureBack = BlockTextureDefault.get("machines/covers/drain/back");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IFluidHandler);
    }

    @Override
    public void onTickPre(byte aCoverSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && !aData.mStopped && aData.mTileEntity instanceof IFluidHandler) {
            if (CS.SERVER_TIME % 100L == 10L && CS.SIDES_TOP_HORIZONTAL[aCoverSide] && aData.mTileEntity.getWorld().isRaining()) {
                Block tInFront;
                BiomeGenBase tBiome = aData.mTileEntity.getBiome();
                if (tBiome.rainfall > 0.0f && (double)tBiome.temperature >= 0.2 && !((tInFront = aData.mTileEntity.getBlockAtSide(aCoverSide)) instanceof BlockLiquid) && !(tInFront instanceof IFluidBlock) && !tInFront.isSideSolid((IBlockAccess)aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), CS.FORGE_DIR_OPPOSITES[aCoverSide]) && !tInFront.isSideSolid((IBlockAccess)aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), CS.FORGE_DIR[1])) {
                    boolean temp = false;
                    if (tInFront instanceof BlockMetaType || tInFront instanceof BlockSlab || tInFront instanceof BlockStairs) {
                        temp = aData.mTileEntity.getRainOffset(CS.OFFX[aCoverSide], CS.OFFY[aCoverSide] + 1, CS.OFFZ[aCoverSide]);
                    } else {
                        boolean bl = temp = aData.mTileEntity.getRainOffset(CS.OFFX[aCoverSide], CS.OFFY[aCoverSide], CS.OFFZ[aCoverSide]) && (CS.SIDES_TOP[aCoverSide] || aData.mTileEntity.getBlockOffset(CS.OFFX[aCoverSide], -1, CS.OFFZ[aCoverSide]).isSideSolid((IBlockAccess)aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getY() - 1, aData.mTileEntity.getOffsetZ(aCoverSide), CS.FORGE_DIR[1]));
                    }
                    if (temp) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Water.make((long)Math.max(1.0f, tBiome.rainfall * 10000.0f) * (long)(aData.mTileEntity.getWorld().isThundering() ? 2 : 1)), true);
                    }
                }
            }
            if (CS.SERVER_TIME % 100L == 50L && (FL.XP.exists() || FL.Mob.exists())) {
                for (Entity tEntity : aData.mTileEntity.getWorld().getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getBoundingBox((double)(aData.mTileEntity.getOffsetX(aCoverSide, 2) - 1), (double)(aData.mTileEntity.getOffsetY(aCoverSide, 2) - 1), (double)(aData.mTileEntity.getOffsetZ(aCoverSide, 2) - 1), (double)(aData.mTileEntity.getOffsetX(aCoverSide, 2) + 2), (double)(aData.mTileEntity.getOffsetY(aCoverSide, 2) + 2), (double)(aData.mTileEntity.getOffsetZ(aCoverSide, 2) + 2)))) {
                    if (tEntity.isDead || !(tEntity instanceof EntityXPOrb)) continue;
                    if (MD.OB.mLoaded) {
                        try {
                            if (FL.fillAll((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.XP.make(LiquidXpUtils.xpToLiquidRatio((int)((EntityXPOrb)tEntity).getXpValue())), true)) {
                                UT.Sounds.send("random.orb", 0.1f, (CS.RNGSUS.nextFloat() - CS.RNGSUS.nextFloat()) * 0.35f + 0.9f, (TileEntity)aData.mTileEntity);
                                aData.mTileEntity.getWorld().removeEntity(tEntity);
                                tEntity.setDead();
                                continue;
                            }
                        }
                        catch (Throwable e) {
                            e.printStackTrace(CS.ERR);
                        }
                    }
                    if (!FL.fillAll((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.XP.make((long)(((EntityXPOrb)tEntity).getXpValue() * 20), FL.Mob, UT.Code.units(((EntityXPOrb)tEntity).getXpValue(), 3L, 200L, false)), true)) continue;
                    UT.Sounds.send("random.orb", 0.1f, (CS.RNGSUS.nextFloat() - CS.RNGSUS.nextFloat()) * 0.35f + 0.9f, (TileEntity)aData.mTileEntity);
                    aData.mTileEntity.getWorld().removeEntity(tEntity);
                    tEntity.setDead();
                }
            }
            if (aReceivedBlockUpdate || CS.SERVER_TIME % 20L == 5L) {
                Block tBlock = aData.mTileEntity.getBlockAtSide(aCoverSide);
                FluidStack tFluid = CS.NF;
                if (tBlock instanceof BlockBaseFluid) {
                    byte tMeta = aData.mTileEntity.getMetaDataAtSide(aCoverSide);
                    BlockBaseFluid tFluidBlock = (BlockBaseFluid)tBlock;
                    if (CS.SIDES_HORIZONTAL[aCoverSide] || (tFluidBlock.mDensityDir > 0 ? CS.SIDES_BOTTOM : CS.SIDES_TOP)[aCoverSide]) {
                        byte i;
                        for (i = 0; i <= tMeta && FL.fillAll((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], tFluidBlock.mQuanta.copy(), true); i = (byte)(i + 1)) {
                        }
                        if (i > 0) {
                            WD.set(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), i > tMeta ? CS.NB : tBlock, i > tMeta ? 0L : (long)(tMeta - i), 3L);
                            tFluidBlock.updateFluidBlocks(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), true);
                        }
                    }
                } else {
                    if (tBlock == Blocks.water || tBlock == Blocks.flowing_water) {
                        if (aData.mTileEntity.getMetaDataAtSide(aCoverSide) == 0) {
                            if (WD.infiniteWater(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide))) {
                                FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Water.make(16000L), true);
                            } else {
                                tFluid = FL.Water.make(1000L);
                            }
                        }
                    } else if (tBlock == Blocks.lava || tBlock == Blocks.flowing_lava) {
                        if (aData.mTileEntity.getMetaDataAtSide(aCoverSide) == 0) {
                            tFluid = FL.Lava.make(1000L);
                        }
                    } else if (tBlock == CS.BlocksGT.River || WD.waterstream(tBlock)) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Water.make(16000L), true);
                    } else if (tBlock == CS.BlocksGT.Ocean) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Ocean.make(16000L), true);
                    } else if (tBlock == CS.BlocksGT.Swamp) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Dirty_Water.make(16000L), true);
                    } else if (tBlock instanceof IFluidBlock) {
                        tFluid = ((IFluidBlock)tBlock).drain(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), false);
                    }
                    if (tFluid != null && (CS.SIDES_HORIZONTAL[aCoverSide] || FL.gas(tFluid) || (FL.lighter(tFluid) ? CS.SIDES_BOTTOM : CS.SIDES_TOP)[aCoverSide]) && FL.fillAll((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], tFluid, true)) {
                        if (tBlock instanceof IFluidBlock) {
                            ((IFluidBlock)tBlock).drain(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide), true);
                        } else {
                            aData.mTileEntity.getWorld().setBlockToAir(aData.mTileEntity.getOffsetX(aCoverSide), aData.mTileEntity.getOffsetY(aCoverSide), aData.mTileEntity.getOffsetZ(aCoverSide));
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean onWalkOver(byte aCoverSide, CoverData aData, Entity aEntity) {
        if (CS.SIDES_TOP[aCoverSide] && !aData.mStopped && aData.mTileEntity instanceof IFluidHandler && aData.mTileEntity.isServerSide()) {
            if (aEntity instanceof EntityPlayer) {
                if (MD.OB.mLoaded && CS.SERVER_TIME % 5L == 0L && ((EntityPlayer)aEntity).isSneaking() && FL.XP.exists()) {
                    try {
                        FluidStack tFluid = FL.XP.make(Math.min(1000, LiquidXpUtils.xpToLiquidRatio((int)EnchantmentUtils.getPlayerXP((EntityPlayer)((EntityPlayer)aEntity)))));
                        if (tFluid.amount > 0) {
                            int tDrainedXP = LiquidXpUtils.liquidToXpRatio((int)((int)FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], tFluid, false)));
                            tFluid.amount = LiquidXpUtils.xpToLiquidRatio((int)tDrainedXP);
                            if (tFluid.amount > 0 && FL.fillAll((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], tFluid, true)) {
                                EnchantmentUtils.addPlayerXP((EntityPlayer)((EntityPlayer)aEntity), (int)(-tDrainedXP));
                                UT.Sounds.send("random.orb", 0.1f, (CS.RNGSUS.nextFloat() - CS.RNGSUS.nextFloat()) * 0.35f + 0.9f, aEntity);
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                }
                return true;
            }
            if (CS.SERVER_TIME % 20L == 5L) {
                if (aEntity instanceof EntityGolem) {
                    return false;
                }
                if (aEntity.getClass() == EntitySquid.class) {
                    FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.InkSquid.make(1L), true);
                    return true;
                }
                if (aEntity instanceof EntitySlime) {
                    if (aEntity.getClass() == EntitySlime.class) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Slime_Green.make(Math.max(1, ((EntitySlime)aEntity).getSlimeSize())), true);
                        return true;
                    }
                    if (aEntity.getClass() == EntityMagmaCube.class) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Blaze.make(Math.max(1, ((EntitySlime)aEntity).getSlimeSize())), true);
                        return true;
                    }
                    String tClass = UT.Reflection.getLowercaseClass(aEntity);
                    if (tClass.equalsIgnoreCase("EntityTFMazeSlime")) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Slime_Green.make(Math.max(1, ((EntitySlime)aEntity).getSlimeSize())), true);
                        return true;
                    }
                    if (tClass.equalsIgnoreCase("KingBlueSlime")) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Slime_Blue.make(4L), true);
                        return true;
                    }
                    if (tClass.equalsIgnoreCase("BlueSlime")) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Slime_Blue.make(1L), true);
                        return true;
                    }
                    if (tClass.equalsIgnoreCase("EntityPinkSlime")) {
                        FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Slime_Pink.make(1L), true);
                        return true;
                    }
                    return false;
                }
                if (aEntity instanceof IAnimals && FL.Sewage.exists() && (!(aEntity instanceof EntityAgeable) || !((EntityAgeable)aEntity).isChild())) {
                    FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aCoverSide], FL.Sewage.make(Math.max(1L, (long)(20.0f * aEntity.width * aEntity.width * aEntity.height))), true);
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + "Collects Fluid Blocks (if not against Gravity)");
        aList.add(LH.Chat.CYAN + "Collects Rainwater (not in Dry or Cold Areas)");
        aList.add(LH.Chat.CYAN + "Will work infinitely in River and Lake Biomes");
        if (FL.Sewage.exists()) {
            aList.add(LH.Chat.ORANGE + "Will collect Sewage from adult Animals walking on it (Bigger Animals make more)");
        }
        if (FL.XP.exists()) {
            aList.add(LH.Chat.GREEN + "Will collect XP Orbs to make Liquid XP");
        } else if (FL.Mob.exists()) {
            aList.add(LH.Chat.DGREEN + "Will collect XP Orbs to make Mob Essence");
        }
        if (MD.OB.mLoaded) {
            aList.add(LH.Chat.GREEN + "Stand on this and Sneak to drain your XP");
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
    }

    @Override
    public boolean isOpaque(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureFront;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? sTextureFront : (aSide == CS.OPOS[aTextureSide] ? sTextureBack : sTextureSides);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTextureSides;
    }
}

