/*
 * Decompiled with CFR 0.152.
 */
package gregapi.compat.buildcraft;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.ITriggerProvider;
import buildcraft.api.statements.StatementManager;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.LH;
import gregapi.lang.LanguageHandler;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TriggerBC
implements ITriggerExternal,
ITriggerProvider {
    public final String mModID;
    public final String mName;
    public IIcon mIcon;

    public TriggerBC(String aModID, String aName, String aDesciption) {
        this.mModID = aModID;
        this.mName = aName;
        LH.add("bc.trigger." + this.mModID + "." + this.mName, aDesciption);
        StatementManager.registerStatement((IStatement)this);
        StatementManager.registerTriggerProvider((ITriggerProvider)this);
    }

    public String getUniqueTag() {
        return this.mModID + ":" + this.mName;
    }

    public IIcon getIcon() {
        return this.mIcon;
    }

    public void registerIcons(IIconRegister aIconRegister) {
        this.mIcon = aIconRegister.registerIcon(this.mModID + ":triggers/" + this.mName);
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public String getDescription() {
        return LanguageHandler.translate("bc.trigger." + this.mModID + "." + this.mName);
    }

    public IStatementParameter createParameter(int aIndex) {
        return null;
    }

    public IStatement rotateLeft() {
        return null;
    }

    public boolean isTriggerActive(TileEntity aTarget, ForgeDirection aSide, IStatementContainer aSource, IStatementParameter[] aParameters) {
        return this.isApplicable(aTarget, UT.Code.side(aSide)) ? this.isActive(aTarget, UT.Code.side(aSide), aSource, aParameters) : false;
    }

    public Collection<ITriggerInternal> getInternalTriggers(IStatementContainer container) {
        return null;
    }

    public Collection<ITriggerExternal> getExternalTriggers(ForgeDirection aSide, TileEntity aTarget) {
        return this.isApplicable(aTarget, UT.Code.side(aSide)) ? new ArrayListNoNulls<ITriggerExternal>(false, this) : null;
    }

    public abstract boolean isActive(TileEntity var1, byte var2, IStatementContainer var3, IStatementParameter[] var4);

    public abstract boolean isApplicable(TileEntity var1, byte var2);
}

