/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.prefixblock;

import gregapi.block.IBlockPlacable;
import gregapi.block.prefixblock.PrefixBlock;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.util.ST;
import gregapi.util.UT;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class PrefixBlockFallingEntity
extends EntityFallingBlock {
    protected IBlockPlacable mBlock;
    protected ItemStack mStack;

    public PrefixBlockFallingEntity(World aWorld) {
        super(aWorld);
    }

    public PrefixBlockFallingEntity(World aWorld, double aX, double aY, double aZ, IBlockPlacable aBlock, ItemStack aStack) {
        super(aWorld, aX, aY, aZ, (Block)aBlock, 0);
        this.mBlock = aBlock;
        this.mStack = aStack;
        this.field_145810_d = aStack.getTagCompound();
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        ++this.field_145812_b;
        this.motionY -= (double)0.04f;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (!this.worldObj.isRemote) {
            int aX = UT.Code.roundDown(this.posX);
            int aY = UT.Code.roundDown(this.posY);
            int aZ = UT.Code.roundDown(this.posZ);
            if (this.field_145812_b == 1) {
                if (this.worldObj.getBlock(aX, aY, aZ) != super.func_145805_f()) {
                    this.setDead();
                    return;
                }
                this.worldObj.setBlockToAir(aX, aY, aZ);
            }
            if (this.onGround) {
                this.motionX *= (double)0.7f;
                this.motionZ *= (double)0.7f;
                this.motionY *= -0.5;
                if (this.worldObj.getBlock(aX, aY, aZ) != Blocks.piston_extension) {
                    this.setDead();
                    if ((!this.worldObj.canPlaceEntityOnSide(super.func_145805_f(), aX, aY, aZ, true, 1, null, this.mStack) || BlockFalling.func_149831_e((World)this.worldObj, (int)aX, (int)(aY - 1), (int)aZ) || !this.mBlock.placeBlock(this.worldObj, aX, aY, aZ, (byte)1, ST.meta_(this.mStack), this.mStack.getTagCompound(), true, true)) && this.field_145813_c) {
                        if (this.mBlock instanceof PrefixBlock) {
                            for (ItemStack tStack : ((PrefixBlock)this.mBlock).mDrops.getDrops((PrefixBlock)this.mBlock, this.worldObj, aX, aY, aZ, ST.meta_(this.mStack), null, 0, false)) {
                                this.entityDropItem(tStack, 0.0f);
                            }
                        } else {
                            this.entityDropItem(this.mStack, 0.0f);
                        }
                    }
                }
            } else if (this.field_145812_b > 100 && !this.worldObj.isRemote && (aY < 1 || aY > 256) || this.field_145812_b > 600) {
                if (this.field_145813_c) {
                    if (this.mBlock instanceof PrefixBlock) {
                        for (ItemStack tStack : ((PrefixBlock)this.mBlock).mDrops.getDrops((PrefixBlock)this.mBlock, this.worldObj, aX, aY, aZ, ST.meta_(this.mStack), null, 0, false)) {
                            this.entityDropItem(tStack, 0.0f);
                        }
                    } else {
                        this.entityDropItem(this.mStack, 0.0f);
                    }
                }
                this.setDead();
            }
        }
    }

    protected void fall(float p_70069_1_) {
        int i = MathHelper.ceiling_float_int((float)(p_70069_1_ - 1.0f));
        if (i > 0) {
            for (Entity tEntity : new ArrayListNoNulls(this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox))) {
                if (!(tEntity instanceof EntityLivingBase)) continue;
                tEntity.attackEntityFrom(DamageSource.fallingBlock, (float)(CS.TFC_DAMAGE_MULTIPLIER * Math.min(MathHelper.floor_float((float)((float)i * 2.0f)), 40)));
            }
        }
    }

    protected void writeEntityToNBT(NBTTagCompound aNBT) {
        super.writeEntityToNBT(aNBT);
        aNBT.setShort("MetaData", ST.meta_(this.mStack));
    }

    protected void readEntityFromNBT(NBTTagCompound aNBT) {
        super.readEntityFromNBT(aNBT);
        this.mBlock = (IBlockPlacable)super.func_145805_f();
        this.mStack = ST.make(super.func_145805_f(), 1L, (long)aNBT.getShort("MetaData"));
        this.mStack.setTagCompound(this.field_145810_d);
    }

    public Block func_145805_f() {
        return Blocks.gravel;
    }
}

