/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.prefixblock;

import gregapi.GT_API_Proxy;
import gregapi.block.IBlockSyncData;
import gregapi.block.IBlockToolable;
import gregapi.block.IPrefixBlock;
import gregapi.block.ToolCompat;
import gregapi.block.behaviors.Drops;
import gregapi.block.prefixblock.PrefixBlockFallingEntity;
import gregapi.block.prefixblock.PrefixBlockItem;
import gregapi.block.prefixblock.PrefixBlockTileEntity;
import gregapi.code.ModData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.lang.LanguageHandler;
import gregapi.network.INetworkHandler;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.oredict.OreDictPrefix;
import gregapi.random.ExplosionGT;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IRenderedBlock;
import gregapi.render.IRenderedBlockObject;
import gregapi.render.ITexture;
import gregapi.render.RendererBlockTextured;
import gregapi.tileentity.ITileEntity;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mekanism.api.MekanismAPI;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;

public class PrefixBlock
extends Block
implements Runnable,
ITileEntityProvider,
IBlockSyncData,
IRenderedBlock,
IBlockToolable,
IPrefixBlock {
    public Drops mDrops;
    public boolean mRegisterToOreDict = true;
    public boolean mHidden = false;
    public final float mMinX;
    public final float mMinY;
    public final float mMinZ;
    public final float mMaxX;
    public final float mMaxY;
    public final float mMaxZ;
    public final int mHarvestLevelOffset;
    public final int mHarvestLevelMinimum;
    public final int mHarvestLevelMaximum;
    public final ITexture mTexture;
    public final String mNameInternal;
    public final String mTool;
    public final String mModIDOwner;
    public final OreDictPrefix mPrefix;
    public final OreDictMaterialStack mHullMaterial;
    public final OreDictMaterial[] mMaterialList;
    public final float mBaseHardness;
    public final float mBaseResistance;
    public final boolean mGravity;
    public final boolean mBeaconBase;
    public final boolean mEnderDragonProof;
    public final boolean mWitherProof;
    public final boolean mSpawnProof;
    public final boolean mOpaque;
    public final boolean mNormalCube;
    public final boolean mPlacementChecksTemperature;
    public final boolean mPlacementChecksAntimatter;
    public final boolean mCanBurn;
    public final boolean mCanExplode;
    public final boolean mRenderOverlayInWorld;
    public final boolean mCanGlow;
    public final boolean mCanLight;
    public IRenderedBlockObject mRenderingObjectBlock = null;
    public IRenderedBlockObject mRenderingObjectStack = null;
    private static boolean LOCK = false;

    @Deprecated
    public PrefixBlock(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterialStack aHullMaterial, Class<? extends PrefixBlockItem> aItemClass, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, boolean aGravity, boolean aBeaconBase, boolean aEnderDragonProof, boolean aWitherProof, boolean aOpaque, boolean aNormalCube, boolean aPlacementChecksTemperature, boolean aPlacementChecksAntimatter, boolean aCanBurn, boolean aCanExplode, boolean aRenderOverlayInWorld, boolean aCanGlow, boolean aCanLight, boolean aSpawnProof) {
        this(aModIDOwner, aModIDTextures, aNameInternal, aPrefix, aHullMaterial, aItemClass, aDrops, aTexture, aVanillaMaterial, aSoundType, aTool, aBaseHardness, aBaseResistance, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, aGravity, aBeaconBase, aEnderDragonProof, aWitherProof, aOpaque, aNormalCube, aPlacementChecksTemperature, aPlacementChecksAntimatter, aCanBurn, aCanExplode, aRenderOverlayInWorld, aCanGlow, aCanLight, aSpawnProof);
    }

    @Deprecated
    public PrefixBlock(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterialStack aHullMaterial, Class<? extends PrefixBlockItem> aItemClass, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ, boolean aGravity, boolean aBeaconBase, boolean aEnderDragonProof, boolean aWitherProof, boolean aOpaque, boolean aNormalCube, boolean aPlacementChecksTemperature, boolean aPlacementChecksAntimatter, boolean aCanBurn, boolean aCanExplode, boolean aRenderOverlayInWorld, boolean aCanGlow, boolean aCanLight, boolean aSpawnProof) {
        this(aModIDOwner, aModIDTextures, aNameInternal, aPrefix, aHullMaterial, aItemClass, aDrops, aTexture, aVanillaMaterial, aSoundType, aTool, aBaseHardness, aBaseResistance, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ, aGravity, aBeaconBase, aEnderDragonProof, aWitherProof, aOpaque, aNormalCube, aPlacementChecksTemperature, aPlacementChecksAntimatter, aCanBurn, aCanExplode, aRenderOverlayInWorld, aCanGlow, aCanLight, aSpawnProof, OreDictMaterial.MATERIAL_ARRAY);
    }

    public PrefixBlock(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, boolean aGravity, boolean aEnderDragonProof, OreDictMaterial ... aMaterialList) {
        this(aModIDOwner, aModIDTextures, aNameInternal, aPrefix, null, null, aDrops, aTexture, aVanillaMaterial, aSoundType, aTool, aBaseHardness, aBaseResistance, aHarvestLevelOffset, aHarvestLevelMinimum, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, aGravity, false, aEnderDragonProof, false, true, true, false, false, true, true, true, true, true, false, aMaterialList);
    }

    public PrefixBlock(ModData aMod, String aNameInternal, OreDictPrefix aPrefix, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, boolean aGravity, boolean aEnderDragonProof, OreDictMaterial ... aMaterialList) {
        this(aMod.mID, aMod.mID, aNameInternal, aPrefix, null, null, aDrops, aTexture, aVanillaMaterial, aSoundType, aTool, aBaseHardness, aBaseResistance, aHarvestLevelOffset, aHarvestLevelMinimum, 999, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, aGravity, false, aEnderDragonProof, false, true, true, false, false, true, true, true, true, true, false, aMaterialList);
    }

    public PrefixBlock(ModData aMod, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterialStack aHullMaterial, Class<? extends PrefixBlockItem> aItemClass, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ, boolean aGravity, boolean aBeaconBase, boolean aEnderDragonProof, boolean aWitherProof, boolean aOpaque, boolean aNormalCube, boolean aPlacementChecksTemperature, boolean aPlacementChecksAntimatter, boolean aCanBurn, boolean aCanExplode, boolean aRenderOverlayInWorld, boolean aCanGlow, boolean aCanLight, boolean aSpawnProof, OreDictMaterial ... aMaterialList) {
        this(aMod.mID, aMod.mID, aNameInternal, aPrefix, aHullMaterial, aItemClass, aDrops, aTexture, aVanillaMaterial, aSoundType, aTool, aBaseHardness, aBaseResistance, aHarvestLevelOffset, aHarvestLevelMinimum, aHarvestLevelMaximum, aMinX, aMinY, aMinZ, aMaxX, aMaxY, aMaxZ, aGravity, aBeaconBase, aEnderDragonProof, aWitherProof, aOpaque, aNormalCube, aPlacementChecksTemperature, aPlacementChecksAntimatter, aCanBurn, aCanExplode, aRenderOverlayInWorld, aCanGlow, aCanLight, aSpawnProof, aMaterialList);
    }

    public PrefixBlock(String aModIDOwner, String aModIDTextures, String aNameInternal, OreDictPrefix aPrefix, OreDictMaterialStack aHullMaterial, Class<? extends PrefixBlockItem> aItemClass, Drops aDrops, ITexture aTexture, Material aVanillaMaterial, Block.SoundType aSoundType, String aTool, float aBaseHardness, float aBaseResistance, int aHarvestLevelOffset, int aHarvestLevelMinimum, int aHarvestLevelMaximum, double aMinX, double aMinY, double aMinZ, double aMaxX, double aMaxY, double aMaxZ, boolean aGravity, boolean aBeaconBase, boolean aEnderDragonProof, boolean aWitherProof, boolean aOpaque, boolean aNormalCube, boolean aPlacementChecksTemperature, boolean aPlacementChecksAntimatter, boolean aCanBurn, boolean aCanExplode, boolean aRenderOverlayInWorld, boolean aCanGlow, boolean aCanLight, boolean aSpawnProof, OreDictMaterial ... aMaterialList) {
        super(aVanillaMaterial);
        this.mPrefix = aPrefix;
        this.mNameInternal = aNameInternal;
        OreDictMaterial[] oreDictMaterialArray = this.mMaterialList = aMaterialList.length > 0 ? aMaterialList : OreDictMaterial.MATERIAL_ARRAY;
        if (this.mMaterialList[0] != MT.Empty) {
            throw new IllegalArgumentException("The first element of the custom Material List has to be MT.Empty for technical reasons!");
        }
        this.mMinX = (float)aMinX;
        this.mMinY = (float)aMinY;
        this.mMinZ = (float)aMinZ;
        this.mMaxX = (float)aMaxX;
        this.mMaxY = (float)aMaxY;
        this.mMaxZ = (float)aMaxZ;
        this.setStepSound(aSoundType);
        this.mOpaque = aOpaque;
        this.mGravity = aGravity;
        this.mCanBurn = aCanBurn;
        this.mCanGlow = aCanGlow;
        this.mCanLight = aCanLight;
        this.mCanExplode = aCanExplode;
        this.mNormalCube = aNormalCube;
        this.mBeaconBase = aBeaconBase;
        this.mSpawnProof = aSpawnProof;
        this.mWitherProof = aWitherProof;
        this.mEnderDragonProof = aEnderDragonProof;
        this.mRenderOverlayInWorld = aRenderOverlayInWorld;
        this.mPlacementChecksAntimatter = aPlacementChecksAntimatter;
        this.mPlacementChecksTemperature = aPlacementChecksTemperature;
        this.mTool = aTool.toLowerCase();
        this.mTexture = aTexture;
        this.mModIDOwner = aModIDOwner;
        this.mHullMaterial = aHullMaterial;
        this.mBaseHardness = aBaseHardness;
        this.mBaseResistance = aBaseResistance;
        this.mHarvestLevelOffset = aHarvestLevelOffset;
        this.mHarvestLevelMinimum = Math.max(0, aHarvestLevelMinimum);
        this.mHarvestLevelMaximum = Math.max(aHarvestLevelMinimum, aHarvestLevelMaximum);
        this.mPrefix.addTextureSet(aModIDTextures, false);
        LH.add("oredict." + this.mPrefix.dat(MT.Empty).toString(), this.getLocalName(this.mPrefix, MT.Empty));
        LH.add(this.mNameInternal + "." + Short.MAX_VALUE, "Any Sub-Block of this one");
        this.opaque = this.mOpaque;
        this.lightOpacity = this.mOpaque ? 255 : 0;
        ST.register(this, this.mNameInternal, aItemClass == null ? PrefixBlockItem.class : aItemClass);
        this.mPrefix.mRegisteredItems.add(this);
        if (this.mPrefix.contains(TD.Prefix.ORE)) {
            if (CS.COMPAT_FR != null) {
                CS.COMPAT_FR.addToBackpacks("miner", ST.make(this, 1L, 32767L));
            }
            if (CS.COMPAT_IC2 != null && this.mBaseHardness >= 0.0f) {
                for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
                    CS.COMPAT_IC2.valuable(this, i, 3);
                }
            }
        } else if (this.mPrefix.containsAny(TD.Prefix.DUST_BASED, TD.Prefix.INGOT_BASED, TD.Prefix.GEM_BASED)) {
            if (CS.COMPAT_FR != null) {
                CS.COMPAT_FR.addToBackpacks("miner", ST.make(this, 1L, 32767L));
            }
        } else if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("builder", ST.make(this, 1L, 32767L));
        }
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (MD.Mek.mLoaded) {
            try {
                MekanismAPI.addBoxBlacklist((Block)this, (int)Short.MAX_VALUE);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (this.mOpaque) {
            CS.VISUALLY_OPAQUE_BLOCKS.add(this);
        }
        Drops drops = this.mDrops = aDrops == null ? new Drops(this, this, this, this, false, false, 0, 0) : aDrops;
        if (CS.CODE_CLIENT) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.getItemFromBlock((Block)this), (IItemRenderer)RendererBlockTextured.INSTANCE);
        }
        (CS.GAPI.mBeforeInit == null ? CS.GAPI.mBeforePostInit : CS.GAPI.mBeforeInit).add(0, this);
    }

    @Override
    public void run() {
        for (int i = 0; i < this.mMaterialList.length; i = (int)((short)(i + 1))) {
            if (!this.mPrefix.isGeneratingItem(this.mMaterialList[i])) continue;
            LH.add("oredict." + this.mPrefix.dat(this.mMaterialList[i]).toString(), this.getLocalName(this.mPrefix, this.mMaterialList[i]));
        }
        if (this.mRegisterToOreDict) {
            boolean tUnificationAllowed = this.mPrefix.contains(TD.Prefix.UNIFICATABLE) && !this.mPrefix.contains(TD.Prefix.UNIFICATABLE_RECIPES);
            for (int i = 0; i < this.mMaterialList.length; i = (int)((short)(i + 1))) {
                if (!this.mPrefix.isGeneratingItem(this.mMaterialList[i])) continue;
                ItemStack tStack = ST.update_(ST.make(this, 1L, (long)i));
                if (tUnificationAllowed) {
                    OreDictManager.INSTANCE.addTarget_(this.mPrefix, this.mMaterialList[i], tStack);
                    continue;
                }
                OreDictManager.INSTANCE.registerOre_(this.mPrefix, this.mMaterialList[i], tStack);
            }
        }
    }

    public void registerBlockIcons(IIconRegister aIconRegister) {
    }

    public IIcon getIcon(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.getIcon(aSide, this.getMetaDataValue(aWorld, aX, aY, aZ));
    }

    public IIcon getIcon(int aSide, int aMetaData) {
        if (this.mPrefix.mIconIndexBlock >= 0) {
            OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
            if (aMaterial != null && aMaterial.mTextureSetsBlock != null) {
                return aMaterial.mTextureSetsBlock.get(this.mPrefix.mIconIndexBlock).getIcon(0);
            }
            return MT.NULL.mTextureSetsBlock.get(this.mPrefix.mIconIndexBlock).getIcon(0);
        }
        return null;
    }

    public int getRenderColor(int aMetaData) {
        OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
        return aMaterial == null ? super.getRenderColor(aMetaData) : UT.Code.getRGBInt(aMaterial.fRGBa[this.mPrefix.mState]);
    }

    public ITexture getTexture(short aMetaData, boolean aRendersInWorld) {
        if (!this.mRenderOverlayInWorld && aRendersInWorld) {
            return this.mTexture;
        }
        if (this.mPrefix.mIconIndexBlock >= 0) {
            OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
            if (this.mTexture == null) {
                if (aMaterial != null && aMaterial.mTextureSetsBlock != null) {
                    return BlockTextureDefault.get(aMaterial, this.mPrefix, this.mCanGlow && aMaterial.contains(TD.Properties.GLOWING));
                }
                return BlockTextureDefault.get(MT.NULL, this.mPrefix);
            }
            if (aMaterial != null && aMaterial.mTextureSetsBlock != null) {
                return BlockTextureMulti.get(this.mTexture, BlockTextureDefault.get(aMaterial, this.mPrefix, this.mCanGlow && aMaterial.contains(TD.Properties.GLOWING)));
            }
            return BlockTextureMulti.get(this.mTexture, BlockTextureDefault.get(MT.NULL, this.mPrefix));
        }
        return null;
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, ItemStack aStack) {
        return this.getTexture(ST.meta_(aStack), false);
    }

    @Override
    public ITexture getTexture(int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return aShouldSideBeRendered[aSide] ? this.getTexture(this.getMetaDataValue(aWorld, aX, aY, aZ), true) : null;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean setBlockBounds(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return false;
    }

    @Override
    public int getRenderPasses(ItemStack aStack) {
        return 1;
    }

    @Override
    public int getRenderPasses(IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return 1;
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(IBlockAccess aWorld, int aX, int aY, int aZ) {
        TileEntity tRenderParameterTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return this.mRenderingObjectBlock != null ? this.mRenderingObjectBlock : (tRenderParameterTileEntity instanceof IRenderedBlockObject ? (IRenderedBlockObject)tRenderParameterTileEntity : null);
    }

    @Override
    public IRenderedBlockObject passRenderingToObject(ItemStack aStack) {
        return this.mRenderingObjectStack;
    }

    public PrefixBlock setRenderingObject(IRenderedBlockObject aBlock, IRenderedBlockObject aStack) {
        this.mRenderingObjectBlock = aBlock;
        this.mRenderingObjectStack = aStack;
        return this;
    }

    public void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        if (!LOCK) {
            LOCK = true;
            TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
            if (aTileEntity instanceof ITileEntity) {
                ((ITileEntity)aTileEntity).onAdjacentBlockChange(aTileX, aTileY, aTileZ);
            }
            LOCK = false;
        }
    }

    public void onNeighborBlockChange(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        TileEntity aTileEntity = null;
        if (!LOCK) {
            LOCK = true;
            aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
            if (aTileEntity instanceof ITileEntity) {
                ((ITileEntity)aTileEntity).onAdjacentBlockChange(aX, aY, aZ);
            }
            LOCK = false;
        }
        this.scheduleUpdateIfNeeded(aWorld, aX, aY, aZ, aTileEntity);
    }

    public boolean scheduleUpdateIfNeeded(World aWorld, int aX, int aY, int aZ, TileEntity aTileEntity) {
        if (this.mGravity && aY > 0 && BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ)) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 2);
            return true;
        }
        if (aTileEntity == null) {
            return false;
        }
        if (!this.mCanBurn && !this.mCanExplode) {
            return false;
        }
        if (this.mPrefix.contains(TD.Prefix.DUST_BASED)) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 2);
            return true;
        }
        OreDictMaterial aMaterial = this.getMetaMaterial(aTileEntity);
        if (aMaterial.containsAny(TD.Properties.FLAMMABLE, TD.Properties.EXPLOSIVE, TD.Atomic.ALKALI_METAL)) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 2);
            return true;
        }
        return false;
    }

    public void onBlockExploded(World aWorld, int aX, int aY, int aZ, Explosion aExplosion) {
        if (aWorld.isRemote) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity != null) {
            CS.LAST_BROKEN_TILEENTITY.set(aTileEntity);
        }
        OreDictMaterial aMaterial = this.getMetaMaterial(aTileEntity);
        aWorld.setBlockToAir(aX, aY, aZ);
        if (aMaterial != null && (this.mCanExplode && aMaterial.contains(TD.Properties.EXPLOSIVE) || this.mCanBurn && aMaterial.contains(TD.Properties.FLAMMABLE) && this.mPrefix.contains(TD.Prefix.DUST_BASED))) {
            try {
                ExplosionGT.explode(aWorld, null, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 648648000L) * 0.7f / 6.48648E8f, true, true);
            }
            catch (StackOverflowError e) {
                CS.ERR.println("WARNING: StackOverflow during Explosion has been prevented at: " + aX + " ; " + aY + " ; " + aZ);
            }
        }
    }

    public float getExplosionResistance(Entity par1Entity, World aWorld, int aX, int aY, int aZ, double explosionX, double explosionY, double explosionZ) {
        OreDictMaterial aMaterial = this.getMetaMaterial((IBlockAccess)aWorld, aX, aY, aZ);
        if (aMaterial != null && (this.mCanExplode && aMaterial.contains(TD.Properties.EXPLOSIVE) || this.mCanBurn && aMaterial.contains(TD.Properties.FLAMMABLE) && this.mPrefix.contains(TD.Prefix.DUST_BASED))) {
            return 0.0f;
        }
        return this.mBaseResistance * (float)(1 + this.getHarvestLevel(aWorld.getBlockMetadata(aX, aY, aZ)));
    }

    public boolean onBlockEventReceived(World aWorld, int aX, int aY, int aZ, int aID, int aData) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return aTileEntity == null || aTileEntity.receiveClientEvent(aID, aData);
    }

    public int getDamageValue(World aWorld, int aX, int aY, int aZ) {
        return this.getMetaDataValue((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public ItemStack getPickBlock(MovingObjectPosition aTarget, World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return this.getItemStackFromBlock((IBlockAccess)aWorld, aX, aY, aZ, (byte)6);
    }

    public void breakBlock(World aWorld, int aX, int aY, int aZ, Block aBlock, int par6) {
        TileEntity tTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (tTileEntity != null) {
            CS.LAST_BROKEN_TILEENTITY.set(tTileEntity);
        }
        aWorld.removeTileEntity(aX, aY, aZ);
    }

    @Override
    public boolean placeBlock(World aWorld, int aX, int aY, int aZ, byte aSide, short aMetaData, NBTTagCompound aNBT, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        OreDictMaterial aMaterial = this.getMetaMaterial(aMetaData);
        if (!(aMaterial == null || !aForcePlacement && (this.mPlacementChecksAntimatter && aMaterial.contains(TD.Atomic.ANTIMATTER) || this.mPlacementChecksTemperature && aMaterial.mMeltingPoint <= WD.temperature(aWorld, aX, aY, aZ)) || !aWorld.setBlock(aX, aY, aZ, (Block)this, (int)UT.Code.bind4(aMaterial.mToolQuality), aCauseBlockUpdates ? 3 : 0))) {
            TileEntity tTileEntity = this.createTileEntity(aWorld, aX, aY, aZ, aSide, aMetaData, aNBT);
            WD.te(aWorld, aX, aY, aZ, tTileEntity, aCauseBlockUpdates);
            this.scheduleUpdateIfNeeded(aWorld, aX, aY, aZ, tTileEntity);
            if (!aWorld.isRemote) {
                GT_API_Proxy.SCHEDULED_TILEENTITY_UPDATES.add((PrefixBlockTileEntity)tTileEntity);
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getItemStackFromBlock(IBlockAccess aWorld, int aX, int aY, int aZ, byte aSide) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        return ST.make((Block)this, 1L, (long)this.getMetaDataValue(aTileEntity), aTileEntity instanceof PrefixBlockTileEntity ? ((PrefixBlockTileEntity)aTileEntity).mItemNBT : null);
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, UT.Code.side(aSide));
        return aMaterial == null || !this.mCanBurn || aMaterial.mMaterial.contains(TD.Properties.UNBURNABLE) ? 0 : (aMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) ? 100 : 0) + (aMaterial.mMaterial.contains(TD.Properties.BURNING) ? 200 : 0);
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, UT.Code.side(aSide));
        return aMaterial == null || !this.mCanBurn || aMaterial.mMaterial.contains(TD.Properties.UNBURNABLE) ? 0 : (aMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) ? 100 : 0) + (aMaterial.mMaterial.contains(TD.Properties.BURNING) ? 200 : 0);
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        OreDictMaterialStack aMaterial = this.getMaterialAtSide((IBlockAccess)aWorld, aX, aY, aZ, UT.Code.side(aSide));
        return aMaterial != null && this.mCanBurn && aMaterial.mMaterial.contains(TD.Properties.FLAMMABLE) && aMaterial.mMaterial.contains(TD.Properties.UNBURNABLE);
    }

    public boolean canEntityDestroy(IBlockAccess aWorld, int aX, int aY, int aZ, Entity aEntity) {
        if (aEntity instanceof EntityDragon) {
            if (this.mEnderDragonProof) {
                return false;
            }
            OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, (byte)6);
            return aMaterial == null || !aMaterial.mMaterial.contains(TD.Properties.ENDER_DRAGON_PROOF);
        }
        if (aEntity instanceof EntityWither) {
            if (this.mWitherProof) {
                return false;
            }
            OreDictMaterialStack aMaterial = this.getMaterialAtSide(aWorld, aX, aY, aZ, (byte)6);
            return aMaterial == null || !aMaterial.mMaterial.contains(TD.Properties.WITHER_PROOF);
        }
        return true;
    }

    @Override
    public long onToolClick(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, World aWorld, byte aSide, int aX, int aY, int aZ, float aHitX, float aHitY, float aHitZ) {
        OreDictMaterial aMaterial = this.getMetaMaterial((IBlockAccess)aWorld, aX, aY, aZ);
        if (!aWorld.isRemote && aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add("This is " + this.getLocalName(this.mPrefix, aMaterial));
            }
            return 1L;
        }
        if (!aWorld.isRemote && aTool.equals("prospector") && this.mPrefix.contains(TD.Prefix.ORE)) {
            if (aChatReturn != null) {
                aChatReturn.add(this.getLocalName(OP.ore, aMaterial) + "!");
            }
            return 100L;
        }
        return ToolCompat.onToolClick(this, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aWorld, aSide, aX, aY, aZ, aHitX, aHitY, aHitZ);
    }

    @Override
    public OreDictMaterialStack getMaterialAtSide(IBlockAccess aWorld, int aX, int aY, int aZ, byte aSide) {
        if (this.mHullMaterial != null) {
            return this.mHullMaterial;
        }
        OreDictMaterial aMaterial = this.getMetaMaterial(aWorld, aX, aY, aZ);
        return aMaterial == null ? null : OM.stack(this.mPrefix, aMaterial);
    }

    @Override
    public void setExtendedMetaData(IBlockAccess aWorld, int aX, int aY, int aZ, short aMetaData) {
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        if (aTileEntity == null && aWorld instanceof World) {
            aTileEntity = WD.te((World)aWorld, aX, aY, aZ, this.createTileEntity((World)aWorld, aX, aY, aZ, (byte)6, aMetaData, null), false);
        }
        if (aTileEntity instanceof PrefixBlockTileEntity) {
            ((PrefixBlockTileEntity)aTileEntity).mMetaData = aMetaData;
        }
        if (aWorld instanceof World && ((World)aWorld).isRemote) {
            WD.update(aWorld, aX, aY, aZ);
        }
    }

    @Override
    public short getExtendedMetaData(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getMetaDataValue(aWorld, aX, aY, aZ);
    }

    @Override
    public boolean removeMaterialFromSide(World aWorld, int aX, int aY, int aZ, byte aSide, OreDictMaterialStack aMaterial) {
        OreDictMaterialStack tMaterial = this.getMaterialAtSide((IBlockAccess)aWorld, aX, aY, aZ, aSide);
        if (aMaterial.mMaterial == tMaterial.mMaterial && aMaterial.mAmount > 0L && aMaterial.mAmount <= tMaterial.mAmount) {
            ItemStack tStack = OM.dust(aMaterial.mMaterial, tMaterial.mAmount - aMaterial.mAmount);
            if (tStack != null) {
                ST.drop(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, tStack);
            }
            aWorld.setBlockToAir(aX, aY, aZ);
            return true;
        }
        return false;
    }

    public void updateTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (aWorld.isRemote || this.checkGravity(aWorld, aX, aY, aZ)) {
            return;
        }
        TileEntity aTileEntity = aWorld.getTileEntity(aX, aY, aZ);
        OreDictMaterial aMaterial = this.getMetaMaterial(aTileEntity);
        if (aMaterial != null) {
            if (this.mCanBurn && (this.mPrefix.contains(TD.Prefix.DUST_BASED) || this.mCanExplode && aMaterial.contains(TD.Properties.EXPLOSIVE)) && aMaterial.contains(TD.Properties.FLAMMABLE) && WD.temperature(aWorld, aX, aY, aZ) > 373L) {
                aWorld.setBlockToAir(aX, aY, aZ);
                try {
                    ExplosionGT.explode(aWorld, null, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (aMaterial.contains(TD.Properties.EXPLOSIVE) ? (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 648648000L) * 0.5f : (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 648648000L) * 0.33f) / 6.48648E8f, true, true);
                }
                catch (StackOverflowError e) {
                    CS.ERR.println("WARNING: StackOverflow during Explosion has been prevented at: " + aX + " ; " + aY + " ; " + aZ);
                }
                return;
            }
            if ((this.mCanBurn || this.mCanExplode) && aMaterial.contains(TD.Atomic.ALKALI_METAL)) {
                boolean tExplode = false;
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    Block tBlock = aWorld.getBlock(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]);
                    if (tBlock != Blocks.water && tBlock != Blocks.flowing_water) continue;
                    aWorld.setBlockToAir(aX + CS.OFFX[tSide], aY + CS.OFFY[tSide], aZ + CS.OFFZ[tSide]);
                    tExplode = true;
                }
                if (tExplode) {
                    aWorld.setBlockToAir(aX, aY, aZ);
                    try {
                        ExplosionGT.explode(aWorld, null, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (aMaterial.contains(TD.Properties.EXPLOSIVE) ? (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 648648000L) * 0.5f : (float)(this.mPrefix.mAmount > 0L ? this.mPrefix.mAmount : 648648000L) * 0.33f) / 6.48648E8f, true, true);
                    }
                    catch (StackOverflowError e) {
                        CS.ERR.println("WARNING: StackOverflow during Explosion has been prevented at: " + aX + " ; " + aY + " ; " + aZ);
                    }
                    return;
                }
            }
        }
    }

    public void dropBlockAsItemWithChance(World aWorld, int aX, int aY, int aZ, int aMeta, float aChance, int aFortune) {
        ArrayList<ItemStack> tList = this.mDrops.getDrops(this, aWorld, aX, aY, aZ, aFortune, false);
        aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)0, (int)aFortune, (float)aChance, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
        for (ItemStack tStack : tList) {
            if (!(CS.RNGSUS.nextFloat() <= aChance)) continue;
            this.dropBlockAsItem(aWorld, aX, aY, aZ, tStack);
        }
    }

    public void harvestBlock(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        aPlayer.addStat(StatList.mineBlockStatArray[PrefixBlock.getIdFromBlock((Block)this)], 1);
        UT.Entities.exhaust(aPlayer, 0.025f);
        boolean aSilkTouch = EnchantmentHelper.getSilkTouchModifier((EntityLivingBase)aPlayer);
        int aFortune = EnchantmentHelper.getFortuneModifier((EntityLivingBase)aPlayer);
        ArrayList<ItemStack> tList = this.mDrops.getDrops(this, aWorld, aX, aY, aZ, aFortune, aSilkTouch);
        float aChance = ForgeEventFactory.fireBlockHarvesting(tList, (World)aWorld, (Block)this, (int)aX, (int)aY, (int)aZ, (int)0, (int)aFortune, (float)1.0f, (boolean)aSilkTouch, (EntityPlayer)aPlayer);
        for (ItemStack tStack : tList) {
            if (!(CS.RNGSUS.nextFloat() <= aChance)) continue;
            this.dropBlockAsItem(aWorld, aX, aY, aZ, tStack);
        }
    }

    public final ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aUnusableMetaData, int aFortune) {
        return this.mDrops.getDrops(this, aWorld, aX, aY, aZ, aFortune, false);
    }

    public int getExpDrop(IBlockAccess aWorld, int aMeta, int aFortune) {
        return this.mDrops.getExp(this);
    }

    public int getRenderBlockPass() {
        return ITexture.Util.MC_ALPHA_BLENDING ? 1 : 0;
    }

    public void getSubBlocks(Item aItem, CreativeTabs aCreativeTab, List aList) {
        aItem.getSubItems(aItem, aCreativeTab, aList);
    }

    public final TileEntity createNewTileEntity(World aWorld, int aMeta) {
        return null;
    }

    public final TileEntity createTileEntity(World aWorld, int aMeta) {
        return null;
    }

    public String toString() {
        return this.mNameInternal;
    }

    public String getUnlocalizedName() {
        return this.mNameInternal;
    }

    public String getLocalizedName() {
        return StatCollector.translateToLocal((String)this.mNameInternal);
    }

    public String getHarvestTool(int aMaterialToolQuality) {
        return this.mTool;
    }

    public boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.getBoundingBox((double)((float)aX + this.mMinX), (double)((float)aY + this.mMinY), (double)((float)aZ + this.mMinZ), (double)((float)aX + this.mMaxX), (double)((float)aY + this.mMaxY), (double)((float)aZ + this.mMaxZ));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return AxisAlignedBB.getBoundingBox((double)((float)aX + this.mMinX), (double)((float)aY + this.mMinY), (double)((float)aZ + this.mMinZ), (double)((float)aX + this.mMaxX), (double)((float)aY + this.mMaxY), (double)((float)aZ + this.mMaxZ));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess aWorld, int aX, int aY, int aZ) {
        this.setBlockBounds(this.mMinX, this.mMinY, this.mMinZ, this.mMaxX, this.mMaxY, this.mMaxZ);
    }

    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return this.mBaseHardness < 0.0f ? -1.0f : (this.mBaseHardness == 0.0f ? 0.0f : Math.max(1.0f, this.mBaseHardness * (float)(1 + this.getHarvestLevel(aWorld.getBlockMetadata(aX, aY, aZ)))));
    }

    public int getRenderType() {
        return RendererBlockTextured.INSTANCE == null ? super.getRenderType() : RendererBlockTextured.INSTANCE.mRenderID;
    }

    public int getHarvestLevel(int aMaterialToolQuality) {
        return (int)UT.Code.bind_(this.mHarvestLevelMinimum, this.mHarvestLevelMaximum, this.mHarvestLevelOffset + aMaterialToolQuality);
    }

    public int tickRate(World aWorld) {
        return 2;
    }

    public int colorMultiplier(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getRenderColor(this.getMetaDataValue(aWorld, aX, aY, aZ));
    }

    public int getLightOpacity() {
        return this.mOpaque ? 255 : 0;
    }

    public boolean isBeaconBase(IBlockAccess aWorld, int aX, int aY, int aZ, int aBeaconX, int aBeaconY, int aBeaconZ) {
        return this.mBeaconBase;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.mOpaque;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.mNormalCube;
    }

    public boolean hasTileEntity(int aMeta) {
        return true;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public final boolean isOpaqueCube() {
        return this.mOpaque;
    }

    public boolean canSilkHarvest() {
        return false;
    }

    public boolean func_149730_j() {
        return this.mOpaque;
    }

    public boolean canCreatureSpawn(EnumCreatureType aType, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return !this.mSpawnProof;
    }

    public boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        this.setBlockBoundsBasedOnState(aWorld, aX, aY, aZ);
        return super.shouldSideBeRendered(aWorld, aX, aY, aZ, aSide);
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, ItemStack aStack) {
        return true;
    }

    @Override
    public boolean usesRenderPass(int aRenderPass, IBlockAccess aWorld, int aX, int aY, int aZ, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    public PrefixBlock setHidden(boolean aHidden) {
        this.mHidden = aHidden;
        return this;
    }

    public String getLocalName(OreDictPrefix aPrefix, OreDictMaterial aMaterial) {
        return LanguageHandler.getLocalName(aPrefix, aMaterial);
    }

    public short getMetaDataValue(TileEntity aTileEntity) {
        return aTileEntity instanceof PrefixBlockTileEntity ? ((PrefixBlockTileEntity)aTileEntity).mMetaData : (short)0;
    }

    public short getMetaDataValue(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getMetaDataValue(aWorld.getTileEntity(aX, aY, aZ));
    }

    public OreDictMaterial getMetaMaterial(int aMetaData) {
        return UT.Code.exists(aMetaData, this.mMaterialList) ? this.mMaterialList[aMetaData] : null;
    }

    public OreDictMaterial getMetaMaterial(TileEntity aTileEntity) {
        return this.getMetaMaterial(aTileEntity instanceof PrefixBlockTileEntity ? (int)((PrefixBlockTileEntity)aTileEntity).mMetaData : 0);
    }

    public OreDictMaterial getMetaMaterial(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this.getMetaMaterial(aWorld.getTileEntity(aX, aY, aZ));
    }

    public TileEntity createTileEntity(World aWorld, int aX, int aY, int aZ, byte aSide, short aMetaData, NBTTagCompound aNBT) {
        PrefixBlockTileEntity rTileEntity = new PrefixBlockTileEntity();
        if (aNBT != null) {
            rTileEntity.readFromNBT(aNBT);
        }
        rTileEntity.mMetaData = aMetaData;
        rTileEntity.mItemNBT = aNBT == null ? null : (aNBT.hasKey("gt.nbt.drop") ? aNBT.getCompoundTag("gt.nbt.drop") : aNBT);
        return rTileEntity;
    }

    protected boolean checkGravity(World aWorld, int aX, int aY, int aZ) {
        if (this.mGravity && aY > 0 && aWorld.getTileEntity(aX, aY, aZ) != null && BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ)) {
            if (!BlockFalling.fallInstantly && aWorld.checkChunksExist(aX - 32, aY - 32, aZ - 32, aX + 32, aY + 32, aZ + 32)) {
                if (!aWorld.isRemote) {
                    aWorld.spawnEntityInWorld((Entity)new PrefixBlockFallingEntity(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, this, this.getItemStackFromBlock((IBlockAccess)aWorld, aX, aY, aZ, (byte)1)));
                }
            } else {
                short tMetaData = this.getMetaDataValue((IBlockAccess)aWorld, aX, aY, aZ);
                if (tMetaData > 0) {
                    aWorld.setBlockToAir(aX, aY, aZ);
                    while (BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ) && aY > 0) {
                        --aY;
                    }
                    if (aY > 0) {
                        this.placeBlock(aWorld, aX, aY, aZ, (byte)1, tMetaData, null, false, true);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void receiveDataByte(IBlockAccess aWorld, int aX, int aY, int aZ, byte aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataShort(IBlockAccess aWorld, int aX, int aY, int aZ, short aData, INetworkHandler aNetworkHandler) {
        this.setExtendedMetaData(aWorld, aX, aY, aZ, aData);
    }

    @Override
    public void receiveDataInteger(IBlockAccess aWorld, int aX, int aY, int aZ, int aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataLong(IBlockAccess aWorld, int aX, int aY, int aZ, long aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataByteArray(IBlockAccess aWorld, int aX, int aY, int aZ, byte[] aData, INetworkHandler aNetworkHandler) {
    }

    @Override
    public void receiveDataName(IBlockAccess aWorld, int aX, int aY, int aZ, String aData, INetworkHandler aNetworkHandler) {
        TileEntity aTileEntity;
        if (UT.Code.stringValid(aData) && (aTileEntity = aWorld.getTileEntity(aX, aY, aZ)) instanceof PrefixBlockTileEntity) {
            if (((PrefixBlockTileEntity)aTileEntity).mItemNBT == null) {
                ((PrefixBlockTileEntity)aTileEntity).mItemNBT = UT.NBT.make();
            }
            ((PrefixBlockTileEntity)aTileEntity).mItemNBT.setTag("display", (NBTBase)UT.NBT.makeString(((PrefixBlockTileEntity)aTileEntity).mItemNBT.getCompoundTag("display"), "Name", aData));
        }
    }
}

