/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlock;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityClassContainer;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.block.multitileentity.MultiTileEntityItemInternal;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackMap;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.CreativeTab;
import gregapi.recipes.Recipe;
import gregapi.render.RendererBlockTextured;
import gregapi.util.CR;
import gregapi.util.ST;
import gregapi.util.UT;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class MultiTileEntityRegistry {
    private static final HashMap<String, MultiTileEntityRegistry> NAMED_REGISTRIES = new HashMap();
    private static final ItemStackMap<ItemStackContainer, MultiTileEntityRegistry> REGISTRIES = new ItemStackMap();
    private static final HashSetNoNulls<Class<?>> sRegisteredTileEntities = new HashSetNoNulls();
    private static final HashSetNoNulls<String> sRegisteredTileEntityClassNames = new HashSetNoNulls();
    private final HashSetNoNulls<Class<?>> mRegisteredTileEntities = new HashSetNoNulls();
    public HashMap<Short, CreativeTab> mCreativeTabs = new HashMap();
    public Map<Short, MultiTileEntityClassContainer> mRegistry = new HashMap<Short, MultiTileEntityClassContainer>();
    public List<MultiTileEntityClassContainer> mRegistrations = new ArrayListNoNulls<MultiTileEntityClassContainer>();
    public final String mNameInternal;
    public final MultiTileEntityBlockInternal mBlock;
    public short mLastRegisteredID = Short.MAX_VALUE;

    private static final MultiTileEntityBlockInternal regblock(String aNameInternal, MultiTileEntityBlockInternal aBlock, Class<? extends ItemBlock> aItemClass) {
        ST.register(aBlock, aNameInternal, aItemClass);
        return aBlock;
    }

    public MultiTileEntityRegistry(String aNameInternal) {
        this(aNameInternal, new MultiTileEntityBlockInternal(), MultiTileEntityItemInternal.class);
    }

    public MultiTileEntityRegistry(String aNameInternal, MultiTileEntityBlockInternal aBlock, Class<? extends ItemBlock> aItemClass) {
        this(aNameInternal, aBlock, aItemClass, RendererBlockTextured.INSTANCE);
    }

    public MultiTileEntityRegistry(String aNameInternal, MultiTileEntityBlockInternal aBlock, Class<? extends ItemBlock> aItemClass, Object aItemRenderer) {
        this(aNameInternal, MultiTileEntityRegistry.regblock(aNameInternal, aBlock, aItemClass));
        if (CS.CODE_CLIENT) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.getItemFromBlock((Block)this.mBlock), (IItemRenderer)(aItemRenderer == null ? RendererBlockTextured.INSTANCE : (IItemRenderer)aItemRenderer));
        }
    }

    public MultiTileEntityRegistry(String aNameInternal, MultiTileEntityBlockInternal aBlock) {
        if (!CS.GAPI.mStartedPreInit) {
            throw new IllegalStateException("The MultiTileEntity Registry must be initialised at the Preload Phase and not before, because it relies on an ItemBlock being created!");
        }
        if (CS.GAPI.mStartedInit) {
            throw new IllegalStateException("The MultiTileEntity Registry must be initialised at the Preload Phase and not later, because it relies on an ItemBlock being created!");
        }
        this.mNameInternal = aNameInternal;
        this.mBlock = aBlock;
        this.mBlock.mMultiTileEntityRegistry = this;
        REGISTRIES.put(this.mBlock, 32767L, this);
        NAMED_REGISTRIES.put(this.mNameInternal, this);
    }

    public static MultiTileEntityRegistry getRegistry(int aRegistryID) {
        return (MultiTileEntityRegistry)REGISTRIES.get(new ItemStackContainer(Item.getItemById((int)aRegistryID), 1L, 32767L));
    }

    public static MultiTileEntityRegistry getRegistry(String aRegistryName) {
        return NAMED_REGISTRIES.get(aRegistryName);
    }

    public static TileEntity getCanonicalTileEntity(int aRegistryID, int aMultiTileEntityID) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRegistryID);
        if (tRegistry == null) {
            return null;
        }
        MultiTileEntityClassContainer tClassContainer = tRegistry.getClassContainer(aMultiTileEntityID);
        if (tClassContainer == null) {
            return null;
        }
        return tClassContainer.mCanonicalTileEntity;
    }

    public static TileEntity getCanonicalTileEntity(String aRegistryName, int aMultiTileEntityID) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(aRegistryName);
        if (tRegistry == null) {
            return null;
        }
        MultiTileEntityClassContainer tClassContainer = tRegistry.getClassContainer(aMultiTileEntityID);
        if (tClassContainer == null) {
            return null;
        }
        return tClassContainer.mCanonicalTileEntity;
    }

    public int currentID() {
        return ST.id(this.mBlock);
    }

    public ItemStack add(String aLocalised, String aCategoricalName, int aID, int aCreativeTabID, Class<? extends TileEntity> aClass, int aBlockMetaData, int aStackSize, MultiTileEntityBlock aBlock, NBTTagCompound aParameters, Object ... aRecipe) {
        return this.add(aLocalised, aCategoricalName, new MultiTileEntityClassContainer(aID, aCreativeTabID, aClass, aBlockMetaData, aStackSize, aBlock, aParameters), aRecipe);
    }

    public ItemStack add(String aLocalised, String aCategoricalName, MultiTileEntityClassContainer aClassContainer, Object ... aRecipe) {
        Recipe.RecipeMap tMap;
        String tRecipeMapName;
        boolean tFailed = false;
        if (UT.Code.stringInvalid(aLocalised)) {
            CS.ERR.println("MTE REGISTRY ERROR: Localisation Missing!");
            tFailed = true;
        }
        if (aClassContainer == null) {
            CS.ERR.println("MTE REGISTRY ERROR: Class Container is null!");
            tFailed = true;
        } else {
            if (aClassContainer.mClass == null) {
                CS.ERR.println("MTE REGISTRY ERROR: Class inside Class Container is null!");
                tFailed = true;
            }
            if (aClassContainer.mID == Short.MAX_VALUE) {
                CS.ERR.println("MTE REGISTRY ERROR: Class Container uses Wildcard MetaData!");
                tFailed = true;
            }
            if (aClassContainer.mID < 0) {
                CS.ERR.println("MTE REGISTRY ERROR: Class Container uses negative MetaData!");
                tFailed = true;
            }
            if (this.mRegistry.containsKey(aClassContainer.mID)) {
                CS.ERR.println("MTE REGISTRY ERROR: Class Container uses occupied MetaData!");
                tFailed = true;
            }
        }
        if (tFailed) {
            CS.ERR.println("MTE REGISTRY ERROR: STACKTRACE START");
            int i = 0;
            for (StackTraceElement tElement : new Exception().getStackTrace()) {
                if (i++ >= 5 || tElement.getClassName().startsWith("sun")) break;
                CS.ERR.println("\tat " + tElement);
            }
            CS.ERR.println("MTE REGISTRY ERROR: STACKTRACE END");
            return null;
        }
        assert (aClassContainer != null);
        LH.add(this.mNameInternal + "." + aClassContainer.mID, aLocalised);
        this.mRegistry.put(aClassContainer.mID, aClassContainer);
        this.mLastRegisteredID = aClassContainer.mID;
        this.mRegistrations.add(aClassContainer);
        if (!this.mCreativeTabs.containsKey(aClassContainer.mCreativeTabID)) {
            this.mCreativeTabs.put(aClassContainer.mCreativeTabID, new CreativeTab(this.mNameInternal + "." + aClassContainer.mCreativeTabID, aCategoricalName, Item.getItemFromBlock((Block)this.mBlock), aClassContainer.mCreativeTabID));
        }
        if (sRegisteredTileEntityClassNames.add(aClassContainer.mCanonicalTileEntity.getClass().getName()) && sRegisteredTileEntities.add(aClassContainer.mCanonicalTileEntity.getClass())) {
            if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirst) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirst)aClassContainer.mCanonicalTileEntity).onRegistrationFirst(this, aClassContainer.mID);
            }
            if (CS.CODE_CLIENT && aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirstClient) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirstClient)aClassContainer.mCanonicalTileEntity).onRegistrationFirstClient(this, aClassContainer.mID);
            }
        }
        if (this.mRegisteredTileEntities.add(aClassContainer.mCanonicalTileEntity.getClass())) {
            if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirstOfRegister) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirstOfRegister)aClassContainer.mCanonicalTileEntity).onRegistrationFirstOfRegister(this, aClassContainer.mID);
            }
            if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationFirstOfRegisterClient) {
                ((IMultiTileEntity.IMTE_OnRegistrationFirstOfRegisterClient)aClassContainer.mCanonicalTileEntity).onRegistrationFirstOfRegisterClient(this, aClassContainer.mID);
            }
        }
        if (aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistration) {
            ((IMultiTileEntity.IMTE_OnRegistration)aClassContainer.mCanonicalTileEntity).onRegistration(this, aClassContainer.mID);
        }
        if (CS.CODE_CLIENT && aClassContainer.mCanonicalTileEntity instanceof IMultiTileEntity.IMTE_OnRegistrationClient) {
            ((IMultiTileEntity.IMTE_OnRegistrationClient)aClassContainer.mCanonicalTileEntity).onRegistrationClient(this, aClassContainer.mID);
        }
        if (aRecipe != null && aRecipe.length > 1) {
            if (aRecipe[0] instanceof Object[]) {
                aRecipe = (Object[])aRecipe[0];
            }
            if (aRecipe.length > 2) {
                CR.shaped(this.getItem(aClassContainer.mID), CR.DEF_REV_NCC, aRecipe);
            }
        }
        if (UT.Code.stringValid(tRecipeMapName = aClassContainer.mParameters.getString("gt.recipemap")) && (tMap = Recipe.RecipeMap.RECIPE_MAPS.get(tRecipeMapName)) != null) {
            tMap.mRecipeMachineList.add(this.getItem(aClassContainer.mID));
        }
        if (UT.Code.stringValid(tRecipeMapName = aClassContainer.mParameters.getString("gt.fuelmap")) && (tMap = Recipe.RecipeMap.RECIPE_MAPS.get(tRecipeMapName)) != null) {
            tMap.mRecipeMachineList.add(this.getItem(aClassContainer.mID));
        }
        return this.getItem(aClassContainer.mID);
    }

    public ItemStack getItem() {
        return this.getItem(this.mLastRegisteredID, 1L, null);
    }

    public ItemStack getItem(NBTTagCompound aNBT) {
        return this.getItem(this.mLastRegisteredID, 1L, aNBT);
    }

    public ItemStack getItem(int aID) {
        return this.getItem(aID, 1L, null);
    }

    public ItemStack getItem(int aID, NBTTagCompound aNBT) {
        return this.getItem(aID, 1L, aNBT);
    }

    public ItemStack getItem(int aID, long aAmount) {
        return this.getItem(aID, aAmount, null);
    }

    public ItemStack getItem(int aID, long aAmount, NBTTagCompound aNBT) {
        MultiTileEntityContainer tTileEntityContainer;
        ItemStack rStack = ST.make(this.mBlock, (long)((int)aAmount), (long)aID);
        if (aNBT == null) {
            aNBT = UT.NBT.make();
        }
        if (aNBT.hasNoTags() && (tTileEntityContainer = this.getNewTileEntityContainer(aID, aNBT)) != null) {
            ((IMultiTileEntity)tTileEntityContainer.mTileEntity).writeItemNBT(aNBT);
        }
        UT.NBT.set(rStack, aNBT);
        return rStack;
    }

    public String getLocal(int aID) {
        return LH.get(this.mNameInternal + "." + aID);
    }

    public MultiTileEntityClassContainer getClassContainer(int aID) {
        return this.mRegistry.get((short)aID);
    }

    public MultiTileEntityClassContainer getClassContainer(ItemStack aStack) {
        return this.mRegistry.get(ST.meta_(aStack));
    }

    public TileEntity getNewTileEntity(int aID) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(null, 0, 0, 0, aID, null);
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public TileEntity getNewTileEntity(World aWorld, int aX, int aY, int aZ, int aID) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(aWorld, aX, aY, aZ, aID, null);
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public TileEntity getNewTileEntity(ItemStack aStack) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(null, 0, 0, 0, ST.meta_(aStack), aStack.getTagCompound());
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public TileEntity getNewTileEntity(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
        MultiTileEntityContainer tContainer = this.getNewTileEntityContainer(aWorld, aX, aY, aZ, ST.meta_(aStack), aStack.getTagCompound());
        return tContainer == null ? null : tContainer.mTileEntity;
    }

    public MultiTileEntityContainer getNewTileEntityContainer(ItemStack aStack) {
        return this.getNewTileEntityContainer(null, 0, 0, 0, ST.meta_(aStack), aStack.getTagCompound());
    }

    public MultiTileEntityContainer getNewTileEntityContainer(World aWorld, int aX, int aY, int aZ, ItemStack aStack) {
        return this.getNewTileEntityContainer(aWorld, aX, aY, aZ, ST.meta_(aStack), aStack.getTagCompound());
    }

    public MultiTileEntityContainer getNewTileEntityContainer(int aID, NBTTagCompound aNBT) {
        return this.getNewTileEntityContainer(null, 0, 0, 0, aID, aNBT);
    }

    public MultiTileEntityContainer getNewTileEntityContainer(World aWorld, int aX, int aY, int aZ, int aID, NBTTagCompound aNBT) {
        MultiTileEntityClassContainer tClass = this.mRegistry.get((short)aID);
        if (tClass == null || tClass.mBlock == null) {
            return null;
        }
        MultiTileEntityContainer rContainer = new MultiTileEntityContainer((TileEntity)UT.Reflection.callConstructor(tClass.mClass, -1, null, true, new Object[0]), tClass.mBlock, tClass.mBlockMetaData);
        if (rContainer.mTileEntity == null) {
            return null;
        }
        rContainer.mTileEntity.setWorldObj(aWorld);
        rContainer.mTileEntity.xCoord = aX;
        rContainer.mTileEntity.yCoord = aY;
        rContainer.mTileEntity.zCoord = aZ;
        ((IMultiTileEntity)rContainer.mTileEntity).initFromNBT(aNBT == null || aNBT.hasNoTags() ? tClass.mParameters : UT.NBT.fuse(aNBT, tClass.mParameters), (short)aID, (short)Block.getIdFromBlock((Block)this.mBlock));
        return rContainer;
    }

    public static void onServerStart() {
        for (Class<?> tClass : sRegisteredTileEntities) {
            if (!IMultiTileEntity.IMTE_OnServerStart.class.isAssignableFrom(tClass)) continue;
            try {
                ((IMultiTileEntity.IMTE_OnServerStart)tClass.newInstance()).onServerStart();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    public static void onServerStop() {
        for (Class<?> tClass : sRegisteredTileEntities) {
            if (!IMultiTileEntity.IMTE_OnServerStop.class.isAssignableFrom(tClass)) continue;
            try {
                ((IMultiTileEntity.IMTE_OnServerStop)tClass.newInstance()).onServerStop();
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    public static void onServerLoad(File aSaveLocation) {
        for (Class<?> tClass : sRegisteredTileEntities) {
            if (!IMultiTileEntity.IMTE_OnServerLoad.class.isAssignableFrom(tClass)) continue;
            try {
                ((IMultiTileEntity.IMTE_OnServerLoad)tClass.newInstance()).onServerLoad(aSaveLocation);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }

    public static void onServerSave(File aSaveLocation) {
        for (Class<?> tClass : sRegisteredTileEntities) {
            if (!IMultiTileEntity.IMTE_OnServerSave.class.isAssignableFrom(tClass)) continue;
            try {
                ((IMultiTileEntity.IMTE_OnServerSave)tClass.newInstance()).onServerSave(aSaveLocation);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
    }
}

